/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.gui.waypoint;

import b100.minimap.Minimap;
import b100.minimap.gui.GuiButton;
import b100.minimap.gui.GuiButtonNavigation;
import b100.minimap.gui.GuiNavigationContainer;
import b100.minimap.gui.GuiScreen;
import b100.minimap.gui.GuiScrollableContainer;
import b100.minimap.gui.waypoint.GuiCreateWaypoint;
import b100.minimap.gui.waypoint.GuiWaypointButton;
import b100.minimap.mc.IDimension;
import b100.minimap.utils.WaypointSorter;
import b100.minimap.waypoint.Waypoint;
import java.util.ArrayList;
import java.util.List;

public class GuiWaypoints
extends GuiScreen {
    public GuiScrollableContainer waypointsContainer;
    public GuiNavigationContainer navTop;
    public GuiNavigationContainer navBottom;
    public String title;
    public GuiButton titleButton;

    public GuiWaypoints(GuiScreen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void onInit() {
        this.waypointsContainer = this.add(new GuiScrollableContainer(this, 10));
        this.updateWaypointList(Minimap.instance.worldData.dimension);
        this.navBottom = this.add(new GuiNavigationContainer(this, this.waypointsContainer, GuiNavigationContainer.Position.BOTTOM));
        this.navBottom.add(new GuiButtonNavigation(this, "Back", this.waypointsContainer).addActionListener(e -> this.back()));
        this.navBottom.add(new GuiButtonNavigation(this, "Create", this.waypointsContainer).addActionListener(e -> this.createWaypoint()));
        this.navTop = this.add(new GuiNavigationContainer(this, this.waypointsContainer, GuiNavigationContainer.Position.TOP));
        this.titleButton = this.navTop.add(new GuiButtonNavigation(this, this.title, this.waypointsContainer));
    }

    public void updateWaypointList(IDimension dimension) {
        Waypoint waypoint;
        int i;
        this.waypointsContainer.elements.clear();
        this.title = "Waypoints [" + dimension.getDisplayName() + "]";
        List<Waypoint> allWaypoints = this.minimap.worldData.getWaypoints();
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        for (i = 0; i < allWaypoints.size(); ++i) {
            waypoint = allWaypoints.get(i);
            if (waypoint.dimension != dimension) continue;
            waypoints.add(waypoint);
        }
        waypoints.sort(new WaypointSorter(this.mc.getThePlayer()));
        for (i = 0; i < waypoints.size(); ++i) {
            waypoint = (Waypoint)waypoints.get(i);
            this.waypointsContainer.addScrollable(new GuiWaypointButton(this, waypoint));
        }
    }

    @Override
    public void onResize() {
        this.waypointsContainer.elementsPerPage = Math.max(10, (this.height - 140) / (this.waypointsContainer.elementHeight + 1));
        super.onResize();
    }

    public void createWaypoint() {
        this.utils.displayGui(new GuiCreateWaypoint(this));
    }

    @Override
    public void onGuiOpened() {
        this.init();
    }
}

