/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.mc.impl;

import b100.minimap.gui.GuiScreen;
import b100.minimap.gui.IGuiUtils;
import b100.minimap.mc.impl.GuiWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.sound.SoundCategory;

public class GuiUtilsImpl
implements IGuiUtils {
    public Minecraft mc;

    public GuiUtilsImpl(Minecraft mc) {
        this.mc = mc;
    }

    @Override
    public void drawString(String string, int x, int y, int color) {
        this.mc.font.drawStringWithShadow(string, x, y, color);
    }

    @Override
    public void drawCenteredString(String string, int x, int y, int color) {
        this.mc.font.drawCenteredString(string, x, y, color);
    }

    @Override
    public int getStringWidth(String string) {
        return this.mc.font.getStringWidth(string);
    }

    @Override
    public void drawRectangle(int x, int y, int w, int h, int color) {
        Tessellator tessellator = Tessellator.instance;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int x0 = x;
        int y0 = y;
        int x1 = x + w;
        int y1 = y + h;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(r, g, b, a);
        tessellator.addVertex((double)x0, (double)y0, 0.0);
        tessellator.addVertex((double)x0, (double)y1, 0.0);
        tessellator.addVertex((double)x1, (double)y1, 0.0);
        tessellator.addVertex((double)x1, (double)y0, 0.0);
        tessellator.draw();
    }

    @Override
    public void playButtonSound() {
        this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
    }

    @Override
    public boolean isGuiOpened() {
        return this.mc.currentScreen != null;
    }

    @Override
    public boolean isMinimapGuiOpened() {
        return this.mc.currentScreen instanceof GuiWrapper;
    }

    @Override
    public void displayGui(GuiScreen screen) {
        if (screen != null) {
            GuiWrapper wrapper = new GuiWrapper(screen);
            this.mc.displayScreen((Screen)wrapper);
            wrapper.opened(this.mc, wrapper.width, wrapper.height);
        } else {
            this.mc.displayScreen(null);
        }
    }

    @Override
    public GuiScreen getCurrentScreen() {
        if (this.mc.currentScreen instanceof GuiWrapper) {
            GuiWrapper guiWrapper = (GuiWrapper)this.mc.currentScreen;
            return guiWrapper.minimapGui;
        }
        return null;
    }

    @Override
    public void drawIcon(int icon, int x, int y, int color) {
        this.mc.textureManager.loadTexture("/minimap/minimap/gui.png").bind();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        if (a == 0) {
            a = 255;
        }
        int iconX = icon & 3;
        int iconY = icon >> 2;
        float u0 = (float)iconX / 4.0f;
        float v0 = (float)iconY / 4.0f;
        float u1 = (float)(iconX + 1) / 4.0f;
        float v1 = (float)(iconY + 1) / 4.0f;
        int x1 = x + 8;
        int y1 = y + 8;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(r, g, b, a);
        tessellator.addVertexWithUV((double)x, (double)y, 0.0, (double)u0, (double)v0);
        tessellator.addVertexWithUV((double)x, (double)y1, 0.0, (double)u0, (double)v1);
        tessellator.addVertexWithUV((double)x1, (double)y1, 0.0, (double)u1, (double)v1);
        tessellator.addVertexWithUV((double)x1, (double)y, 0.0, (double)u1, (double)v0);
        tessellator.draw();
    }

    @Override
    public void drawIconWithShadow(int icon, int x, int y, int color) {
        int shadowColor = color;
        int alphaChannelOnly = shadowColor & 0xFF000000;
        shadowColor = (shadowColor & 0xFCFCFC) >> 2;
        this.drawIcon(icon, x + 1, y + 1, shadowColor += alphaChannelOnly);
        this.drawIcon(icon, x, y, color);
    }

    @Override
    public void drawTexturedRectangle(int x, int y, int w, int h, float u0, float v0, float u1, float v1, int color) {
        Tessellator tessellator = Tessellator.instance;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int x0 = x;
        int y0 = y;
        int x1 = x + w;
        int y1 = y + h;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(r, g, b, a);
        tessellator.addVertexWithUV((double)x0, (double)y0, 0.0, (double)u0, (double)v0);
        tessellator.addVertexWithUV((double)x0, (double)y1, 0.0, (double)u0, (double)v1);
        tessellator.addVertexWithUV((double)x1, (double)y1, 0.0, (double)u1, (double)v1);
        tessellator.addVertexWithUV((double)x1, (double)y0, 0.0, (double)u1, (double)v0);
        tessellator.draw();
    }
}

