/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.render;

import b100.minimap.Minimap;
import b100.minimap.config.MapConfig;
import b100.minimap.mc.IDimension;
import b100.minimap.mc.IPlayer;
import b100.minimap.render.MapChunk;
import b100.minimap.render.MapTileManager;
import b100.minimap.render.MapTileRenderer;
import b100.minimap.render.RenderHelper;
import b100.minimap.render.WorldListener;
import b100.minimap.render.style.MapStyle;
import b100.minimap.utils.Utils;
import b100.minimap.waypoint.Waypoint;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class MapRender
implements WorldListener {
    private Minimap minimap;
    private World world;
    private RenderHelper renderHelper = new RenderHelper();
    private List<MapChunk> renderChunksUnused = new ArrayList<MapChunk>();
    private List<MapChunk> renderChunksUsed = new ArrayList<MapChunk>();
    private Map<Integer, MapChunk> chunks = new HashMap<Integer, MapChunk>();
    public final MapTileManager mapTileManager;
    public final MapTileRenderer mapTileRenderer;
    public final int maskTexture;
    public final int mapTexture;
    private ByteBuffer colorBuffer = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
    private IntBuffer colorBufferInt = this.colorBuffer.asIntBuffer();
    public Tessellator tessellator;
    public MapConfig mapConfig;
    public int viewRadius = 16;
    public double playerPosX;
    public double playerPosY;
    public double playerPosZ;
    public int playerBlockX;
    public int playerBlockZ;
    public double playerRotation;
    public int playerChunkX;
    public int playerChunkZ;
    public int zoom;
    public int mapPosX;
    public int mapPosY;
    public int mapWidth;
    public int mapHeight;
    public int mapCenterX;
    public int mapCenterY;
    public int tileSize;
    public int iconSize = 16;
    public boolean roundMap;
    public boolean enableMask;
    public boolean enableMaskTexture;
    public float frameOpacity;
    public boolean rotateFrame;

    public MapRender(Minimap minimap) {
        this.minimap = minimap;
        this.mapTileManager = new MapTileManager(minimap, 64);
        this.mapTileRenderer = new MapTileRenderer(minimap);
        this.maskTexture = minimap.minecraftHelper.generateTexture();
        this.mapTexture = minimap.minecraftHelper.generateTexture();
    }

    public void setStyle(MapStyle style) {
        Utils.setTextureImage(this.mapTexture, style.getMapTexture(), style.useLinearFiltering(), false);
        Utils.setTextureImage(this.maskTexture, style.getMaskTexture(), style.useLinearFiltering(), false);
        style.closeStreams();
    }

    public void renderMap(float partialTicks) {
        IPlayer player = this.minimap.minecraftHelper.getThePlayer();
        this.playerPosX = player.getPosX(partialTicks);
        this.playerPosY = player.getPosY(partialTicks);
        this.playerPosZ = player.getPosZ(partialTicks);
        this.playerChunkX = MathHelper.floor((double)this.playerPosX) >> 4;
        this.playerChunkZ = MathHelper.floor((double)this.playerPosZ) >> 4;
        this.playerRotation = player.getRotationYaw();
        this.mapConfig = this.minimap.config.mapConfig;
        this.viewRadius = 16;
        this.updateChunks();
        GL11.glPushMatrix();
        this.drawMapOnScreen();
        GL11.glPopMatrix();
    }

    private void drawMapOnScreen() {
        this.tessellator = Tessellator.instance;
        int displayWidth = this.minimap.minecraftHelper.getDisplayWidth();
        int displayHeight = this.minimap.minecraftHelper.getDisplayHeight();
        this.mapWidth = (Integer)this.mapConfig.width.value * 16;
        this.mapHeight = (Integer)this.mapConfig.width.value * 16;
        this.roundMap = (Boolean)this.mapConfig.roundMap.value;
        this.enableMask = this.enableMaskTexture = ((Boolean)this.minimap.config.mask.value).booleanValue();
        this.frameOpacity = (float)((Integer)this.minimap.config.mapConfig.frameOpacity.value).intValue() / 100.0f;
        this.rotateFrame = this.roundMap && (Boolean)this.minimap.config.mapConfig.rotateFrame.value != false;
        int pad = this.iconSize;
        if (((Boolean)this.mapConfig.fullscreenMap.value).booleanValue()) {
            this.mapWidth = this.mapHeight = Math.min(displayWidth - pad * 2, displayHeight - pad * 2);
            this.mapPosX = (displayWidth - this.mapWidth) / 2;
            this.mapPosY = (displayHeight - this.mapHeight) / 2;
            if ((Integer)this.mapConfig.fullscreenType.value == 1) {
                this.roundMap = false;
                this.frameOpacity = 0.0f;
                this.enableMaskTexture = false;
            }
            this.zoom = (int)Math.pow(2.0, ((Integer)this.mapConfig.fullscreenZoomLevel.value).intValue());
        } else {
            this.zoom = (int)Math.pow(2.0, ((Integer)this.mapConfig.zoomLevel.value).intValue());
            int position = (Integer)this.mapConfig.position.value;
            this.mapPosX = position == 1 || position == 3 ? displayWidth - this.mapWidth - pad : pad;
            this.mapPosY = position == 2 || position == 3 ? displayHeight - this.mapHeight - pad : pad;
            if (position == 4) {
                this.mapPosX = (displayWidth - this.mapWidth) / 2;
                this.mapPosY = pad;
            }
            if (position == 5) {
                this.mapPosX = (displayWidth - this.mapWidth) / 2;
                this.mapPosY = (displayHeight - this.mapHeight) / 2;
            }
        }
        this.mapCenterX = this.mapPosX + this.mapWidth / 2;
        this.mapCenterY = this.mapPosY + this.mapHeight / 2;
        this.tileSize = 16 * this.zoom;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.enableMask) {
            GL11.glEnable((int)2929);
            GL11.glDepthFunc((int)519);
            GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            GL11.glDisable((int)3553);
            GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
            this.tessellator.startDrawingQuads();
            this.tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            this.renderHelper.drawRectangle(this.tessellator, 0.0, 0.0, displayWidth, displayHeight, 0.0f, 0.0f, 0.0f, 0.0f, 32.0);
            this.tessellator.setColorOpaque_F(0.0f, 0.0f, 1.0f);
            this.renderHelper.drawRectangle(this.tessellator, this.mapPosX, this.mapPosY, this.mapWidth, this.mapHeight, 0.0f, 0.0f, 1.0f, 1.0f, -32.0);
            this.tessellator.draw();
            GL11.glDepthFunc((int)515);
            if (this.enableMaskTexture) {
                GL11.glEnable((int)3553);
                GL11.glBindTexture((int)3553, (int)this.maskTexture);
                this.tessellator.startDrawingQuads();
                this.tessellator.setColorOpaque_F(0.0f, 1.0f, 0.0f);
                this.renderHelper.drawRectangle(this.tessellator, this.mapPosX, this.mapPosY, this.mapWidth, this.mapHeight, 0.0f, 0.0f, 1.0f, 1.0f, 64.0);
                this.tessellator.draw();
            }
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        GL11.glDisable((int)3553);
        GL11.glColor4d((double)0.1, (double)0.1, (double)0.1, (double)0.9);
        this.tessellator.startDrawingQuads();
        this.renderHelper.drawRectangle(this.tessellator, this.mapPosX, this.mapPosY, this.mapWidth, this.mapHeight, 0.0f, 0.0f, 0.0f, 0.0f, 0.0);
        this.tessellator.draw();
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.mapCenterX, (double)this.mapCenterY, (double)0.0);
        boolean rotate = (Boolean)this.minimap.config.mapConfig.rotateMap.value;
        if (rotate) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(-this.playerRotation + 180.0), (double)0.0, (double)0.0, (double)1.0);
        }
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glEnable((int)3553);
        this.renderMapTiles();
        if (rotate) {
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (this.frameOpacity > 0.0f) {
            GL11.glDisable((int)3008);
            GL11.glBindTexture((int)3553, (int)this.mapTexture);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.frameOpacity);
            this.tessellator.startDrawingQuads();
            if (this.rotateFrame) {
                this.renderHelper.drawRotatedRectangle(this.tessellator, this.mapPosX, this.mapPosY, this.mapWidth, this.mapHeight, 0.0f, 0.0f, 1.0f, 1.0f, 64.0, Math.toRadians(this.playerRotation));
            } else {
                this.renderHelper.drawRectangle(this.tessellator, this.mapPosX, this.mapPosY, this.mapWidth, this.mapHeight, 0.0f, 0.0f, 1.0f, 1.0f, 64.0);
            }
            this.tessellator.draw();
            GL11.glEnable((int)3008);
        }
        GL11.glDisable((int)2929);
        this.renderWaypoints();
        this.renderPlayerArrow();
        if (((Boolean)this.minimap.config.showTiles.value).booleanValue()) {
            GL11.glBindTexture((int)3553, (int)this.mapTileManager.texture);
            GL11.glDisable((int)3553);
            GL11.glColor3d((double)0.0, (double)0.0, (double)0.0);
            this.tessellator.startDrawingQuads();
            this.renderHelper.drawRectangle(this.tessellator, 0.0, 0.0, 512.0, 512.0, 0.0f, 0.0f, 1.0f, 1.0f, 0.0);
            this.tessellator.draw();
            GL11.glEnable((int)3553);
            GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
            this.tessellator.startDrawingQuads();
            this.renderHelper.drawRectangle(this.tessellator, 0.0, 0.0, 512.0, 512.0, 0.0f, 0.0f, 1.0f, 1.0f, 0.0);
            this.tessellator.draw();
        }
    }

    public void renderMapTiles() {
        GL11.glBindTexture((int)3553, (int)this.mapTileManager.texture);
        boolean startedDrawing = false;
        this.playerBlockX = MathHelper.floor((double)this.playerPosX);
        this.playerBlockZ = MathHelper.floor((double)this.playerPosZ);
        int wh = this.mapWidth / 2;
        int hh = this.mapHeight / 2;
        for (int i = 0; i < this.renderChunksUsed.size(); ++i) {
            MapChunk mapChunk = this.renderChunksUsed.get(i);
            int distance = Math.max(Math.abs(this.playerChunkX - mapChunk.getPosX()), Math.abs(this.playerChunkZ - mapChunk.getPosZ()));
            if (distance > this.viewRadius + 2) {
                this.renderChunksUsed.remove(i--);
                this.setChunkNotInUse(mapChunk);
                continue;
            }
            int tile = mapChunk.tile;
            if (tile == -1) continue;
            if (!startedDrawing) {
                startedDrawing = true;
                this.tessellator.startDrawingQuads();
            }
            int x0 = mapChunk.getPosX() * 16 * this.zoom - (int)(this.playerPosX * (double)this.zoom);
            int z0 = mapChunk.getPosZ() * 16 * this.zoom - (int)(this.playerPosZ * (double)this.zoom);
            int extend = 0;
            if (((Boolean)this.mapConfig.rotateMap.value).booleanValue() && !this.roundMap) {
                extend = 48;
            }
            if (x0 >= wh + extend || z0 >= hh + extend || x0 + this.tileSize <= -wh - extend || z0 + this.tileSize <= -hh - extend) continue;
            int x1 = x0;
            int y1 = z0;
            this.renderTile(this.tessellator, tile, x1, y1, this.tileSize, this.tileSize, 0);
        }
        if (startedDrawing) {
            this.tessellator.draw();
        }
    }

    public void renderPlayerArrow() {
        this.minimap.minecraftHelper.getTexture("/assets/minimap/player_arrow.png").bind();
        GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        Double angle = null;
        if (!((Boolean)this.mapConfig.rotateMap.value).booleanValue()) {
            angle = Math.toRadians(-this.playerRotation - 90.0);
        }
        this.tessellator.startDrawingQuads();
        this.renderHelper.drawIcon(this.tessellator, this.mapCenterX, this.mapCenterY, this.iconSize, 0.0, angle);
        this.tessellator.draw();
    }

    public void renderWaypoints() {
        if (!((Boolean)this.mapConfig.showWaypoints.value).booleanValue()) {
            return;
        }
        List<Waypoint> waypoints = Minimap.instance.worldData.getWaypoints();
        if (waypoints.size() == 0) {
            return;
        }
        Texture waypointTex = this.minimap.minecraftHelper.getTexture("/assets/minimap/waypoint.png");
        Texture waypointArrowTex = this.minimap.minecraftHelper.getTexture("/assets/minimap/waypoint_arrow.png");
        waypointTex.bind();
        Texture currentTex = waypointTex;
        IDimension currentDimension = this.minimap.worldData.dimension;
        for (int i = 0; i < waypoints.size(); ++i) {
            Waypoint waypoint = waypoints.get(i);
            if (!waypoint.visible || waypoint.dimension != currentDimension) continue;
            double offsetX = ((double)waypoint.x + 0.5) * (double)this.zoom - (double)((int)(this.playerPosX * (double)this.zoom));
            double offsetZ = ((double)waypoint.z + 0.5) * (double)this.zoom - (double)((int)(this.playerPosZ * (double)this.zoom));
            double offsetXSmooth = (double)waypoint.x - this.playerPosX;
            double offsetZSmooth = (double)waypoint.z - this.playerPosZ;
            Double angle = null;
            if (((Boolean)this.mapConfig.rotateMap.value).booleanValue()) {
                double rot = Math.toRadians(this.playerRotation - 90.0);
                double sin = Math.sin(rot);
                double cos = Math.cos(rot);
                double p0xNew = offsetX * sin - offsetZ * cos;
                double p0yNew = offsetX * cos + offsetZ * sin;
                offsetX = p0xNew;
                offsetZ = p0yNew;
                p0xNew = offsetXSmooth * sin - offsetZSmooth * cos;
                p0yNew = offsetXSmooth * cos + offsetZSmooth * sin;
                offsetXSmooth = p0xNew;
                offsetZSmooth = p0yNew;
            }
            double x = (double)this.mapCenterX + offsetX;
            double y = (double)this.mapCenterY + offsetZ;
            boolean isOnMap = true;
            int border = (int)((float)this.mapWidth / 24.0f);
            if (this.roundMap) {
                double dx = x - (double)this.mapCenterX;
                double dy = y - (double)this.mapCenterY;
                double rad = (this.mapWidth - border) / 2;
                double rad2 = (this.mapWidth + this.iconSize / 2) / 2;
                double distance = Math.sqrt(dx * dx + dy * dy);
                boolean bl = isOnMap = distance < rad;
                if (!isOnMap) {
                    distance = Math.sqrt(offsetXSmooth * offsetXSmooth + offsetZSmooth * offsetZSmooth);
                    offsetXSmooth = offsetXSmooth / distance * rad2;
                    offsetZSmooth = offsetZSmooth / distance * rad2;
                    x = offsetXSmooth + (double)this.mapCenterX;
                    y = offsetZSmooth + (double)this.mapCenterY;
                }
            } else {
                boolean bl = isOnMap = x >= (double)(this.mapPosX + border) && y >= (double)(this.mapPosY + border) && x < (double)(this.mapPosX + this.mapWidth - border) && y < (double)(this.mapPosY + this.mapHeight - border);
                if (!isOnMap) {
                    double offXAbs = Math.abs(offsetXSmooth);
                    double offZAbs = Math.abs(offsetZSmooth);
                    if (offZAbs > offXAbs) {
                        x = offsetXSmooth / offZAbs * (double)(this.mapWidth / 2) + (double)this.mapCenterX;
                        y = offsetZSmooth / offZAbs * (double)(this.mapWidth / 2) + (double)this.mapCenterY;
                    } else {
                        x = offsetXSmooth / offXAbs * (double)(this.mapWidth / 2) + (double)this.mapCenterX;
                        y = offsetZSmooth / offXAbs * (double)(this.mapWidth / 2) + (double)this.mapCenterY;
                    }
                }
            }
            float zLevel = 0.0f;
            if (isOnMap) {
                if (currentTex != waypointTex) {
                    waypointTex.bind();
                    currentTex = waypointTex;
                }
            } else {
                angle = Math.atan2(-offsetZSmooth, offsetXSmooth);
                if (currentTex != waypointArrowTex) {
                    waypointArrowTex.bind();
                    currentTex = waypointArrowTex;
                }
                zLevel = 100.0f;
            }
            this.tessellator.startDrawingQuads();
            this.tessellator.setColorOpaque_I(waypoint.color);
            this.renderHelper.drawIcon(this.tessellator, x, y, this.iconSize, zLevel, angle);
            this.tessellator.draw();
            if (!isOnMap || !((Boolean)this.mapConfig.showWaypointLabels.value).booleanValue()) continue;
            int size = (Integer)this.mapConfig.waypointLabelSize.value;
            int w = this.renderHelper.getStringWidth(waypoint.name);
            int x1 = (int)(x - (double)(w * size / 2));
            int y1 = (int)(y + 14.0);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x1, (float)y1, (float)0.0f);
            GL11.glScalef((float)size, (float)size, (float)size);
            x1 = 0;
            y1 = 0;
            GL11.glDisable((int)3553);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            this.tessellator.startDrawingQuads();
            this.renderHelper.drawRectangle(this.tessellator, x1 - 1, y1 - 1, w + 2, 10.0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0);
            this.tessellator.draw();
            GL11.glEnable((int)3553);
            this.renderHelper.drawString(waypoint.name, x1, y1, -1, false);
            currentTex = null;
            GL11.glPopMatrix();
        }
    }

    public void setChunkNotInUse(MapChunk chunk) {
        if (chunk.tile != -1) {
            this.mapTileManager.setTileNotInUse(chunk.tile);
            chunk.tile = -1;
        }
        this.chunks.remove(chunk.getIndex());
        this.renderChunksUnused.add(chunk);
    }

    private void renderTile(Tessellator tessellator, int tile, int x, int y, int width, int height, int zLevel) {
        int tileX = tile % 64;
        int tileY = tile / 64;
        float w = 0.015625f;
        float u0 = (float)tileX / 64.0f;
        float v0 = (float)tileY / 64.0f;
        float u1 = u0 + w;
        float v1 = v0 + w;
        this.renderHelper.drawRectangleInt(tessellator, x, y, width, height, u0, v0, u1, v1, zLevel);
    }

    private void updateChunks() {
        int updates = 0;
        int max = (Integer)this.minimap.config.updateSpeed.value;
        for (int i = -this.viewRadius; i <= this.viewRadius; ++i) {
            for (int j = -this.viewRadius; j <= this.viewRadius; ++j) {
                int tile;
                int chunkX = this.playerChunkX + i;
                int chunkZ = this.playerChunkZ + j;
                int index = MapRender.getChunkIndex(chunkX, chunkZ);
                int x0 = chunkX << 4;
                int z0 = chunkZ << 4;
                MapChunk chunk = this.chunks.get(index);
                if (chunk != null && !chunk.needsUpdate || !this.world.areBlocksLoaded(x0 - 8, 0, z0 - 8, x0 + 24, 0, z0 + 24)) continue;
                if (chunk == null) {
                    chunk = this.getNewMapChunk(chunkX, chunkZ);
                    this.chunks.put(chunk.getIndex(), chunk);
                    this.renderChunksUsed.add(chunk);
                }
                if ((tile = chunk.tile) == -1) {
                    tile = this.mapTileManager.getEmptyTile();
                    if (tile == -1) {
                        return;
                    }
                    chunk.tile = tile;
                }
                chunk.needsUpdate = false;
                boolean rendered = this.mapTileRenderer.render(this.colorBufferInt, chunkX, chunkZ, 16, 16);
                if (rendered) {
                    this.colorBuffer.position(0);
                    this.mapTileManager.setTile(tile, this.colorBuffer);
                } else {
                    this.mapTileManager.setTileNotInUse(chunk.tile);
                    chunk.tile = -1;
                }
                if (++updates < max) continue;
                return;
            }
        }
    }

    public static int getChunkIndex(int posX, int posZ) {
        return (posZ & 0xFFFF) << 16 | posX & 0xFFFF;
    }

    private MapChunk getNewMapChunk(int posX, int posZ) {
        if (this.renderChunksUnused.size() > 0) {
            return this.renderChunksUnused.remove(0).setPosition(posX, posZ);
        }
        return new MapChunk().setPosition(posX, posZ);
    }

    public void updateBlocks(int x0, int y0, int z0, int x1, int y1, int z1) {
        int chunkX0 = x0 >> 4;
        int chunkZ0 = z0 >> 4;
        int chunkX1 = x1 >> 4;
        int chunkZ1 = z1 >> 4;
        for (int chunkX = chunkX0; chunkX <= chunkX1; ++chunkX) {
            for (int chunkZ = chunkZ0; chunkZ <= chunkZ1; ++chunkZ) {
                int index = MapRender.getChunkIndex(chunkX, chunkZ);
                MapChunk chunk = this.chunks.get(index);
                if (chunk == null) continue;
                chunk.needsUpdate = true;
            }
        }
    }

    public void updateAllTiles() {
        for (int i = 0; i < this.renderChunksUsed.size(); ++i) {
            this.renderChunksUsed.get((int)i).needsUpdate = true;
        }
    }

    @Override
    public void onUpdateBlock(int x, int y, int z) {
        this.updateBlocks(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1);
    }

    @Override
    public void onUpdateBlocks(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.updateBlocks(minX - 1, minY - 1, minZ - 1, maxX + 1, maxY + 1, maxZ + 1);
    }

    @Override
    public void onUpdateAllChunks() {
        this.updateAllTiles();
    }

    public void onWorldChange(World world) {
        this.mapTileRenderer.onWorldChanged(world);
        this.world = world;
        while (this.renderChunksUsed.size() > 0) {
            this.setChunkNotInUse(this.renderChunksUsed.remove(0));
        }
    }
}

