/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.render.style;

import b100.minimap.render.style.MapStyle;
import b100.minimap.utils.Utils;
import java.awt.image.BufferedImage;

public class MapStyleGenerated
implements MapStyle {
    public int resolution = 1024;
    public int color;
    public float borderWidth = 8.0f;
    private boolean round;

    public MapStyleGenerated(boolean round, int color) {
        this.round = round;
        this.color = color;
    }

    @Override
    public BufferedImage getMapTexture() {
        int w = this.resolution;
        int h = this.resolution;
        BufferedImage image = new BufferedImage(w, h, 2);
        if (this.round) {
            float centerX = (float)w / 2.0f - 0.5f;
            float centerY = (float)h / 2.0f - 0.5f;
            float maxDistance = Utils.distance(0.0f, 0.0f, centerX, centerY);
            float circleSize = (float)this.resolution / 4.6f;
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    int rgb = this.color & 0xFFFFFF;
                    float distance = maxDistance - Utils.distance(x, y, centerX, centerY);
                    float alpha = this.borderWidth - Math.abs(distance - circleSize);
                    int a = Utils.clamp((int)(alpha * 255.0f), 0, 255);
                    image.setRGB(x, y, a << 24 | rgb);
                }
            }
        } else {
            float bw = this.borderWidth * 2.0f;
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int rgb = this.color & 0xFFFFFF;
                    float alpha = 0.0f;
                    if ((float)x < bw || (float)y < bw || (float)x >= (float)w - bw || (float)y >= (float)h - bw) {
                        alpha = 1.0f;
                    }
                    int a = Utils.clamp((int)(alpha * 255.0f), 0, 255);
                    image.setRGB(x, y, a << 24 | rgb);
                }
            }
        }
        return image;
    }

    @Override
    public BufferedImage getMaskTexture() {
        int w = this.resolution;
        int h = this.resolution;
        BufferedImage image = new BufferedImage(w, h, 2);
        if (this.round) {
            float bw = this.borderWidth / 2.0f;
            float centerX = (float)w / 2.0f - 0.5f;
            float centerY = (float)h / 2.0f - 0.5f;
            float maxDistance = Utils.distance(0.0f, 0.0f, centerX, centerY);
            float circleSize = (float)this.resolution / 4.6f;
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    int rgb = this.color & 0xFFFFFF;
                    float distance = maxDistance - Utils.distance(x, y, centerX, centerY);
                    float alpha = bw - (distance - circleSize);
                    int a = Utils.clamp((int)(alpha * 255.0f), 0, 255);
                    image.setRGB(x, y, a << 24 | rgb);
                }
            }
        }
        return image;
    }

    @Override
    public boolean isRound() {
        return this.round;
    }

    @Override
    public boolean useLinearFiltering() {
        return true;
    }

    @Override
    public void closeStreams() {
    }
}

