/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.render.style;

import b100.minimap.Minimap;
import b100.minimap.render.style.MapStyle;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class MapStyleInternal
implements MapStyle {
    private String path;
    private boolean round;
    private boolean filter;

    public MapStyleInternal(String path, boolean round, boolean filter) {
        this.path = path;
        this.round = round;
        this.filter = filter;
    }

    @Override
    public BufferedImage getMapTexture() {
        if (this.round) {
            return this.getImage(this.path + "roundmap.png");
        }
        return this.getImage(this.path + "squaremap.png");
    }

    @Override
    public BufferedImage getMaskTexture() {
        if (this.round) {
            return this.getImage(this.path + "roundmap_mask.png");
        }
        return this.getImage(this.path + "squaremap_mask.png");
    }

    @Override
    public boolean isRound() {
        return this.round;
    }

    private BufferedImage getImage(String path) {
        return MapStyleInternal.readImage(Minimap.class.getResourceAsStream(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImage(InputStream stream) {
        try {
            BufferedImage bufferedImage = ImageIO.read(stream);
            return bufferedImage;
        }
        catch (Exception e) {
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean useLinearFiltering() {
        return this.filter;
    }

    @Override
    public void closeStreams() {
    }
}

