/*
 * Decompiled with CFR 0.152.
 */
package b100.minimap.utils;

import b100.minimap.Minimap;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;

public abstract class Utils {
    public static void setTextureImage(int texture, BufferedImage image, boolean filter, boolean repeat) {
        GL11.glBindTexture((int)3553, (int)texture);
        int w = image.getWidth();
        int h = image.getHeight();
        int size = w * h * 4;
        ByteBuffer buffer = Minimap.instance.minecraftHelper.getBufferWithCapacity(size);
        buffer.position(0).limit(size);
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int color = image.getRGB(j, i);
                byte a = (byte)(color >> 24 & 0xFF);
                byte r = (byte)(color >> 16 & 0xFF);
                byte g = (byte)(color >> 8 & 0xFF);
                byte b = (byte)(color >> 0 & 0xFF);
                buffer.put(r);
                buffer.put(g);
                buffer.put(b);
                buffer.put(a);
            }
        }
        buffer.position(0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w, (int)h, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        int filterMode = filter ? 9729 : 9728;
        int wrapMode = repeat ? 10497 : 10496;
        GL11.glTexParameteri((int)3553, (int)10241, (int)filterMode);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filterMode);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrapMode);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrapMode);
    }

    public static float distance(float x0, float y0, float x1, float y1) {
        return Utils.length(x1 - x0, y1 - y0);
    }

    public static float length(float x, float y) {
        return (float)Math.sqrt(x * x + y * y);
    }

    public static int brightnessToColor(float brightness) {
        int r = Utils.clamp((int)(brightness * 255.0f), 0, 255);
        return 0xFF000000 | r << 16 | r << 8 | r;
    }

    public static int clamp(int a, int min, int max) {
        if (a > max) {
            return max;
        }
        if (a < min) {
            return min;
        }
        return a;
    }

    public static float clamp(float a, float min, float max) {
        if (a > max) {
            return max;
        }
        if (a < min) {
            return min;
        }
        return a;
    }

    public static float mix(float a, float b, float c) {
        return a * (1.0f - c) + b * c;
    }

    public static int mixColor(int color0, int color1, float f) {
        float a0 = (float)(color0 >> 24 & 0xFF) / 255.0f;
        float r0 = (float)(color0 >> 16 & 0xFF) / 255.0f;
        float g0 = (float)(color0 >> 8 & 0xFF) / 255.0f;
        float b0 = (float)(color0 >> 0 & 0xFF) / 255.0f;
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 >> 0 & 0xFF) / 255.0f;
        float a2 = Utils.mix(a0, a1, f);
        float r2 = Utils.mix(r0, r1, f);
        float g2 = Utils.mix(g0, g1, f);
        float b2 = Utils.mix(b0, b1, f);
        int a = (int)(a2 * 255.0f);
        int r = (int)(r2 * 255.0f);
        int g = (int)(g2 * 255.0f);
        int b = (int)(b2 * 255.0f);
        a = Utils.clamp(a, 0, 255);
        r = Utils.clamp(r, 0, 255);
        g = Utils.clamp(g, 0, 255);
        b = Utils.clamp(b, 0, 255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int multiplyColor(int color0, float brightness) {
        float a0 = (float)(color0 >> 24 & 0xFF) / 255.0f;
        float r0 = (float)(color0 >> 16 & 0xFF) / 255.0f;
        float g0 = (float)(color0 >> 8 & 0xFF) / 255.0f;
        float b0 = (float)(color0 >> 0 & 0xFF) / 255.0f;
        int a = (int)(a0 * brightness * 255.0f);
        int r = (int)(r0 * brightness * 255.0f);
        int g = (int)(g0 * brightness * 255.0f);
        int b = (int)(b0 * brightness * 255.0f);
        a = Utils.clamp(a, 0, 255);
        r = Utils.clamp(r, 0, 255);
        g = Utils.clamp(g, 0, 255);
        b = Utils.clamp(b, 0, 255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int multiplyColor(int color0, int color1) {
        float a0 = (float)(color0 >> 24 & 0xFF) / 255.0f;
        float r0 = (float)(color0 >> 16 & 0xFF) / 255.0f;
        float g0 = (float)(color0 >> 8 & 0xFF) / 255.0f;
        float b0 = (float)(color0 >> 0 & 0xFF) / 255.0f;
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 >> 0 & 0xFF) / 255.0f;
        int a = (int)(a0 * a1 * 255.0f);
        int r = (int)(r0 * r1 * 255.0f);
        int g = (int)(g0 * g1 * 255.0f);
        int b = (int)(b0 * b1 * 255.0f);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static String getValidFileName(String name) {
        int seperator = 45;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) != -1) {
                c = (char)(c + 32);
                str.append(c);
                continue;
            }
            if ("abcdefghijklmnopqrstuvwxyz0123456789".indexOf(c) != -1) {
                str.append(c);
                continue;
            }
            if (str.length() <= 0 || str.charAt(str.length() - 1) == '-') continue;
            str.append('-');
        }
        if (str.length() > 0 && str.charAt(str.length() - 1) == '-') {
            str.deleteCharAt(str.length() - 1);
        }
        if (str.length() == 0) {
            str.append('-');
        }
        return str.toString();
    }

    public static void copyStringToClipboard(String string) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    public static String getClipboardString() {
        try {
            return (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int parseColor(String string) {
        if (string.length() > 8) {
            throw new NumberFormatException();
        }
        int color = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            int charValue;
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                charValue = c - 48;
            } else if (c >= 'a' && c <= 'f') {
                charValue = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                charValue = c - 65 + 10;
            } else {
                throw new NumberFormatException("Invalid character '" + c + "' at index " + i + "!");
            }
            color |= charValue << (string.length() - i - 1 << 2);
        }
        return color;
    }

    public static String toColorString(int color, boolean includeAlpha) {
        int start;
        String hexString = "0123456789abcdef";
        StringBuilder builder = new StringBuilder();
        for (int i = start = includeAlpha ? 0 : 2; i < 8; ++i) {
            int j = color >> (7 - i) * 4 & 0xF;
            builder.append("0123456789abcdef".charAt(j));
        }
        return builder.toString();
    }
}

