/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.core.Global;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import org.lwjgl.input.Keyboard;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoManager;
import toufoumaster.btwaila.gui.components.WailaTextComponent;
import toufoumaster.btwaila.network.packet.PacketRequestEntityData;
import toufoumaster.btwaila.network.packet.PacketRequestTileEntityData;
import toufoumaster.btwaila.tooltips.EntityTooltip;
import toufoumaster.btwaila.tooltips.TileTooltip;
import toufoumaster.btwaila.tooltips.TooltipRegistry;

public class AdvancedInfoComponent
extends WailaTextComponent {
    private static boolean keyPressed = false;

    public AdvancedInfoComponent(String key, Layout layout) {
        super(key, 68, layout);
    }

    public int getAnchorY(ComponentAnchor anchor) {
        return (int)(anchor.yPosition * (float)this.getYSize(Minecraft.getMinecraft()));
    }

    public boolean isVisible(Minecraft minecraft) {
        return minecraft.gameSettings.immersiveMode.drawHotbar();
    }

    @Override
    public void renderPost(Minecraft minecraft, HudIngame HudIngame2, int xScreenSize, int yScreenSize, float partialTick) {
        HitResult hitResult = minecraft.objectMouseOver;
        if (hitResult == null) {
            return;
        }
        if (hitResult.hitType == HitResult.HitType.TILE) {
            TileEntity tileEntity = minecraft.currentWorld.getTileEntity(hitResult.x, hitResult.y, hitResult.z);
            this.renderBlockOverlay(tileEntity);
        } else if (hitResult.hitType == HitResult.HitType.ENTITY) {
            this.renderEntityOverlay(hitResult.entity);
        }
    }

    @Override
    public void renderPreviewPost(Minecraft minecraft, Gui gui, Layout layout, int xScreenSize, int yScreenSize) {
        if (this.modSettings().bTWaila$getKeyDemoCycle().isPressed()) {
            if (!keyPressed) {
                DemoManager.demoOffset = Keyboard.isKeyDown((int)Keyboard.KEY_LSHIFT) ? --DemoManager.demoOffset : ++DemoManager.demoOffset;
                keyPressed = true;
            }
        } else {
            keyPressed = false;
        }
        TileEntity demoTileEntity = DemoManager.getCurrentEntry().tileEntity;
        Entity demoAnimal = DemoManager.getCurrentEntry().entity;
        if (demoTileEntity != null) {
            this.renderBlockOverlay(demoTileEntity);
        } else if (demoAnimal != null) {
            this.renderEntityOverlay(demoAnimal);
        }
    }

    private void renderBlockOverlay(TileEntity tileEntity) {
        this.setScale(((Float)this.modSettings().bTWaila$getScaleTooltips().value).floatValue() + 0.5f);
        if (!((Boolean)this.modSettings().bTWaila$getBlockTooltips().value).booleanValue()) {
            return;
        }
        if (this.minecraft.font != null && ((Boolean)this.modSettings().bTWaila$getBlockAdvancedTooltips().value).booleanValue()) {
            this.drawFunctionalBlocksData(tileEntity);
        }
    }

    private void renderEntityOverlay(Entity entity) {
        Mob Mob2;
        this.setScale(((Float)this.modSettings().bTWaila$getScaleTooltips().value).floatValue() + 0.5f);
        if (!((Boolean)this.modSettings().bTWaila$getEntityTooltips().value).booleanValue()) {
            return;
        }
        boolean isLivingEntity = entity instanceof Mob;
        Mob mob = Mob2 = isLivingEntity ? (Mob)entity : null;
        if (((Boolean)this.modSettings().bTWaila$getEntityAdvancedTooltips().value).booleanValue()) {
            if (this.minecraft.thePlayer instanceof PlayerLocalMultiplayer && BTWaila.canUseAdvancedTooltips) {
                PlayerLocalMultiplayer playerMP = (PlayerLocalMultiplayer)this.minecraft.thePlayer;
                playerMP.sendQueue.addToSendQueue((Packet)new PacketRequestEntityData(entity.id));
            }
            if (isLivingEntity) {
                this.drawEntityHealth(Mob2);
            }
            for (EntityTooltip<?> tooltip : TooltipRegistry.entityTooltips) {
                if (!tooltip.isInstance(entity) || !tooltip.isInList(entity.getClass())) continue;
                tooltip._drawAdvancedTooltip(entity, this);
            }
        }
    }

    private void drawFunctionalBlocksData(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity.worldObj != null) {
            boolean askTileEntity;
            boolean bl = BTWaila.excludeContinuousTileEntityData.get(tileEntity.getClass()) == null || !BTWaila.excludeContinuousTileEntityData.get(tileEntity.getClass()).booleanValue() ? true : (askTileEntity = false);
            if (tileEntity.worldObj == null) {
                return;
            }
            if (!Global.isServer && BTWaila.canUseAdvancedTooltips && askTileEntity) {
                PlayerLocalMultiplayer playerMP = (PlayerLocalMultiplayer)this.minecraft.thePlayer;
                playerMP.sendQueue.addToSendQueue((Packet)new PacketRequestTileEntityData(tileEntity.x, tileEntity.y, tileEntity.z));
                if (tileEntity instanceof TileEntityChest) {
                    this.requestOtherHalfOfChest(playerMP.world, tileEntity.x, tileEntity.y, tileEntity.z, playerMP);
                }
            }
            for (TileTooltip<?> tooltip : TooltipRegistry.tileTooltips) {
                if (!tooltip.isInstance(tileEntity) || !tooltip.isInList(tileEntity.getClass())) continue;
                tooltip._drawAdvancedTooltip(tileEntity, this);
            }
        }
    }

    private void requestOtherHalfOfChest(World world, int x, int y, int z, PlayerLocalMultiplayer playerMP) {
        int meta = world.getBlockMetadata(x, y, z);
        BlockLogicChest.Type type = BlockLogicChest.getTypeFromMeta((int)meta);
        if (type != BlockLogicChest.Type.SINGLE) {
            int otherMeta;
            Direction direction = BlockLogicChest.getDirectionFromMeta((int)meta);
            int otherChestX = x;
            int otherChestZ = z;
            if (direction == Direction.NORTH) {
                if (type == BlockLogicChest.Type.LEFT) {
                    --otherChestX;
                }
                if (type == BlockLogicChest.Type.RIGHT) {
                    ++otherChestX;
                }
            }
            if (direction == Direction.EAST) {
                if (type == BlockLogicChest.Type.LEFT) {
                    --otherChestZ;
                }
                if (type == BlockLogicChest.Type.RIGHT) {
                    ++otherChestZ;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == BlockLogicChest.Type.LEFT) {
                    ++otherChestX;
                }
                if (type == BlockLogicChest.Type.RIGHT) {
                    --otherChestX;
                }
            }
            if (direction == Direction.WEST) {
                if (type == BlockLogicChest.Type.LEFT) {
                    ++otherChestZ;
                }
                if (type == BlockLogicChest.Type.RIGHT) {
                    --otherChestZ;
                }
            }
            if (BlockLogicChest.isChest((World)world, (int)otherChestX, (int)y, (int)otherChestZ) && BlockLogicChest.getDirectionFromMeta((int)(otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ))) == direction) {
                BlockLogicChest.Type otherType = BlockLogicChest.getTypeFromMeta((int)otherMeta);
                if (type == BlockLogicChest.Type.LEFT && otherType == BlockLogicChest.Type.RIGHT || type == BlockLogicChest.Type.RIGHT && otherType == BlockLogicChest.Type.LEFT) {
                    playerMP.sendQueue.addToSendQueue((Packet)new PacketRequestTileEntityData(otherChestX, y, otherChestZ));
                }
            }
        }
    }
}

