/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.gui.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.phys.HitResult;
import org.lwjgl.opengl.GL11;
import toufoumaster.btwaila.demo.DemoManager;

public class HarvestToolComponent
extends HudComponentMovable {
    public HarvestToolComponent(String key, Layout layout) {
        super(key, 18, 18, layout);
    }

    public boolean isVisible(Minecraft minecraft) {
        return minecraft.gameSettings.immersiveMode.drawHotbar() && minecraft.thePlayer.gamemode == Gamemode.survival;
    }

    public void render(Minecraft minecraft, HudIngame HudIngame2, int xScreenSize, int yScreenSize, float f) {
        if (minecraft.objectMouseOver == null) {
            return;
        }
        if (minecraft.objectMouseOver.hitType != HitResult.HitType.TILE) {
            return;
        }
        Block block = minecraft.currentWorld.getBlock(minecraft.objectMouseOver.x, minecraft.objectMouseOver.y, minecraft.objectMouseOver.z);
        this.renderTool(minecraft, block, xScreenSize, yScreenSize);
    }

    public void renderPreview(Minecraft minecraft, Gui gui, Layout layout, int xScreenSize, int yScreenSize) {
        Block<?> block = DemoManager.getCurrentEntry().block;
        if (block != null) {
            this.renderTool(minecraft, block, xScreenSize, yScreenSize);
        }
    }

    protected void renderTool(Minecraft minecraft, Block block, int xScreenSize, int yScreenSize) {
        int x = this.getLayout().getComponentX(minecraft, (HudComponent)this, xScreenSize);
        int y = this.getLayout().getComponentY(minecraft, (HudComponent)this, yScreenSize);
        Item itemHarvestTool = null;
        if (Items.TOOL_PICKAXE_STEEL.canHarvestBlock((Mob)minecraft.thePlayer, new ItemStack(block), block)) {
            itemHarvestTool = Items.TOOL_PICKAXE_STEEL;
        } else if (Items.TOOL_SHEARS_STEEL.canHarvestBlock((Mob)minecraft.thePlayer, new ItemStack(block), block)) {
            itemHarvestTool = Items.TOOL_SHEARS_STEEL;
        } else if (Items.TOOL_AXE_STEEL.canHarvestBlock((Mob)minecraft.thePlayer, new ItemStack(block), block)) {
            itemHarvestTool = Items.TOOL_AXE_STEEL;
        } else if (Items.TOOL_SWORD_STEEL.canHarvestBlock((Mob)minecraft.thePlayer, new ItemStack(block), block)) {
            itemHarvestTool = Items.TOOL_SWORD_STEEL;
        } else if (Items.TOOL_SHOVEL_STEEL.canHarvestBlock((Mob)minecraft.thePlayer, new ItemStack(block), block)) {
            itemHarvestTool = Items.TOOL_SHOVEL_STEEL;
        } else if (Items.TOOL_HOE_STEEL.canHarvestBlock((Mob)minecraft.thePlayer, new ItemStack(block), block)) {
            itemHarvestTool = Items.TOOL_HOE_STEEL;
        }
        if (itemHarvestTool == null) {
            return;
        }
        GL11.glEnable((int)2929);
        Tessellator t = Tessellator.instance;
        ItemModel model = (ItemModel)ItemModelDispatcher.getInstance().getDispatch((Object)itemHarvestTool);
        model.renderItemIntoGui(t, minecraft.font, minecraft.textureManager, itemHarvestTool.getDefaultStack(), x + (this.getXSize(minecraft) - 16) / 2, y + (this.getYSize(minecraft) - 16) / 2, 1.0f);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
    }
}

