/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.gui.components;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScreenHudDesigner;
import net.minecraft.client.gui.guidebook.mobs.MobInfoRegistry;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.entity.EntityRendererItem;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobChicken;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.entity.animal.MobSquid;
import net.minecraft.core.entity.animal.MobWolf;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.entity.monster.MobGhast;
import net.minecraft.core.entity.monster.MobScorpion;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSlime;
import net.minecraft.core.entity.monster.MobSnowman;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.entity.monster.MobZombiePig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.BTWailaClient;
import toufoumaster.btwaila.mixin.interfaces.IOptions;
import toufoumaster.btwaila.util.BarStyle;
import toufoumaster.btwaila.util.ColorOptions;
import toufoumaster.btwaila.util.ProgressBarOptions;
import toufoumaster.btwaila.util.TextureOptions;
import toufoumaster.btwaila.util.TooltipFormatting;

public abstract class WailaTextComponent
extends HudComponentMovable {
    public static EntityRendererItem itemRender = null;
    public static final HashMap<Class<? extends Entity>, ItemStack> entityIconMap = new HashMap();
    public static final int componentTextWidth = 152;
    public int lineHeight = 9;
    protected final int padding = 8;
    protected int offY = 8;
    protected int posX = 0;
    protected float scale = 1.0f;
    public Minecraft minecraft = Minecraft.getMinecraft();
    protected Gui activeGUI;
    protected int xScreenSize;
    protected int yScreenSize;
    protected int ySize;
    private int startY = 0;

    public static void init() {
        WailaTextComponent.addEntityIcon(Player.class, (IItemConvertible)Items.FLAG);
        WailaTextComponent.addEntityIcon(PlayerLocal.class, (IItemConvertible)Items.FLAG);
        WailaTextComponent.addEntityIcon(MobZombieArmored.class, (IItemConvertible)Items.CHAINLINK);
        WailaTextComponent.addEntityIcon(MobCreeper.class, (IItemConvertible)Items.SULPHUR);
        WailaTextComponent.addEntityIcon(MobGhast.class, (IItemConvertible)Items.AMMO_FIREBALL);
        WailaTextComponent.addEntityIcon(MobZombiePig.class, (IItemConvertible)Items.FOOD_PORKCHOP_COOKED);
        WailaTextComponent.addEntityIcon(MobPig.class, (IItemConvertible)Items.FOOD_PORKCHOP_RAW);
        WailaTextComponent.addEntityIcon(MobScorpion.class, (IItemConvertible)Items.STRING);
        WailaTextComponent.addEntityIcon(MobSpider.class, (IItemConvertible)Items.STRING);
        WailaTextComponent.addEntityIcon(MobSkeleton.class, (IItemConvertible)Items.BONE);
        WailaTextComponent.addEntityIcon(MobSlime.class, (IItemConvertible)Items.SLIMEBALL);
        WailaTextComponent.addEntityIcon(MobSnowman.class, (IItemConvertible)Items.AMMO_SNOWBALL);
        WailaTextComponent.addEntityIcon(MobZombie.class, (IItemConvertible)Items.CLOTH);
        WailaTextComponent.addEntityIcon(MobChicken.class, (IItemConvertible)Items.FEATHER_CHICKEN);
        WailaTextComponent.addEntityIcon(MobCow.class, (IItemConvertible)Items.LEATHER);
        WailaTextComponent.addEntityIcon(EntityPainting.class, (IItemConvertible)Items.PAINTING);
        WailaTextComponent.addEntityIcon(MobSheep.class, (IItemConvertible)Blocks.WOOL);
        WailaTextComponent.addEntityIcon(MobSquid.class, (IItemConvertible)Items.DYE);
        WailaTextComponent.addEntityIcon(MobWolf.class, (IItemConvertible)Items.BONE);
        WailaTextComponent.addEntityIcon(EntityMinecart.class, (IItemConvertible)Items.MINECART);
        WailaTextComponent.addEntityIcon(EntityBoat.class, (IItemConvertible)Items.BOAT);
    }

    public static void addEntityIcon(Class<? extends Entity> entityClass, IItemConvertible displayItem) {
        WailaTextComponent.addEntityIcon(entityClass, displayItem.getDefaultStack());
    }

    public static void addEntityIcon(Class<? extends Entity> entityClass, ItemStack displayStack) {
        entityIconMap.put(entityClass, displayStack);
    }

    public IOptions modSettings() {
        return BTWailaClient.modSettings;
    }

    public WailaTextComponent(String key, int ySize, Layout layout) {
        super(key, 152, ySize, layout);
        this.ySize = ySize;
    }

    public int getXSize(Minecraft mc) {
        return 152;
    }

    public void render(Minecraft minecraft, HudIngame HudIngame2, int xScreenSize, int yScreenSize, float partialTick) {
        this.minecraft = minecraft;
        this.activeGUI = HudIngame2;
        this.xScreenSize = xScreenSize;
        this.yScreenSize = yScreenSize;
        if (minecraft.currentScreen instanceof ScreenHudDesigner) {
            return;
        }
        this.startY = this.offY = this.generateOriginalPosY();
        this.posX = this.generateOriginalPosX();
        this.renderPost(minecraft, HudIngame2, xScreenSize, yScreenSize, partialTick);
    }

    public void renderPreview(Minecraft minecraft, Gui gui, Layout layout, int xScreenSize, int yScreenSize) {
        this.minecraft = minecraft;
        this.activeGUI = gui;
        this.xScreenSize = xScreenSize;
        this.yScreenSize = yScreenSize;
        this.startY = this.offY = this.generateOriginalPosY();
        this.posX = this.generateOriginalPosX();
        this.renderPreviewPost(minecraft, gui, layout, xScreenSize, yScreenSize);
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int height() {
        return this.offY - this.startY;
    }

    public abstract void renderPost(Minecraft var1, HudIngame var2, int var3, int var4, float var5);

    public abstract void renderPreviewPost(Minecraft var1, Gui var2, Layout var3, int var4, int var5);

    public Minecraft getGame() {
        return this.minecraft;
    }

    public void addOffY(int offset) {
        this.offY += offset;
    }

    public void subOffY(int offset) {
        this.offY -= offset;
    }

    public int getOffY() {
        return this.offY;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setOffY(int y) {
        this.offY = y;
    }

    public void setPosX(int x) {
        this.posX = x;
    }

    protected void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }

    public int generateOriginalPosY() {
        return this.getLayout().getComponentY(this.minecraft, (HudComponent)this, this.yScreenSize);
    }

    public int generateOriginalPosX() {
        return this.getLayout().getComponentX(this.minecraft, (HudComponent)this, this.xScreenSize);
    }

    public void drawStringWithShadow(String text, int offX, int color) {
        int width = this.minecraft.font.getStringWidth(text);
        this.minecraft.font.drawStringWithShadow(text, this.posX + offX + this.getStartingX(width), this.offY, color);
        this.addOffY(this.getLineHeight());
    }

    public int getStartingX(int width) {
        int startX;
        int diff = this.getXSize(this.minecraft) - width;
        switch ((TooltipFormatting)((Object)this.modSettings().bTWaila$getTooltipFormatting().value)) {
            case LEFT: {
                startX = 0;
                break;
            }
            case CENTERED: {
                startX = diff / 2;
                break;
            }
            case RIGHT: {
                startX = diff;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum: " + this.modSettings().bTWaila$getTooltipFormatting().value);
            }
        }
        return startX;
    }

    public void drawStringWithShadow(String text, int offX) {
        this.drawStringWithShadow(text, offX, 0xFFFFFF);
    }

    public void drawStringJustified(String text, int offX, int maxWidth, int color) {
        String[] words = text.split(" ");
        StringBuilder line = new StringBuilder();
        int wordCount = 0;
        for (String word : words) {
            StringBuilder prevline = new StringBuilder(line.toString());
            line.append(word).append(" ");
            ++wordCount;
            if (this.minecraft.font.getStringWidth(line.toString().trim()) <= maxWidth) continue;
            if (wordCount <= 1) {
                this.drawStringWithShadow(line.toString(), offX, color);
                line = new StringBuilder(word).append(" ");
                wordCount = 0;
                continue;
            }
            this.drawStringWithShadow(prevline.toString(), offX, color);
            line = new StringBuilder(word).append(" ");
            wordCount = 0;
        }
        String remainder = line.toString();
        if (!remainder.isEmpty()) {
            this.drawStringWithShadow(remainder, offX, color);
        }
    }

    public void drawStringCentered(String text) {
        this.drawStringCentered(text, 0xFFFFFF);
    }

    public void drawStringCentered(String text, int color) {
        this.minecraft.font.drawCenteredString(text, this.posX + 76, this.offY, color);
        this.addOffY(this.getLineHeight());
    }

    @Deprecated
    public void drawTextureRectRepeat(int x, int y, int w, int h, int texX, int texY, int tileWidth, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)0, (int)(this.minecraft.resolution.getWidthScreenCoords() - h * this.minecraft.resolution.getScale()), (int)(w * this.minecraft.resolution.getScale()), (int)this.minecraft.resolution.getHeightScreenCoords());
        for (int i = x; i < w; i += tileWidth) {
            for (int j = y; j < h; j += tileWidth) {
                this.activeGUI.drawTexturedModalRect(i, j, texX, texY, tileWidth, tileWidth);
            }
        }
        GL11.glDisable((int)3089);
    }

    public void drawIcon(double x, double y, double w, double h, IconCoordinate coordinate, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        coordinate.parentAtlas.bind();
        double minU = coordinate.getIconUMin();
        double maxU = coordinate.getIconUMax();
        double minV = coordinate.getIconVMin();
        double maxV = coordinate.getIconVMax();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)0, (int)MathHelper.floor((double)((double)this.minecraft.resolution.getHeightScreenCoords() - h * (double)this.minecraft.resolution.getScale())), (int)MathHelper.floor((double)(w * (double)this.minecraft.resolution.getScale())), (int)this.minecraft.resolution.getHeightScreenCoords());
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        for (double i = x; i < w; i += (double)coordinate.width) {
            for (double j = y; j < h; j += (double)coordinate.height) {
                tessellator.addVertexWithUV(i + 0.0, j + (double)coordinate.height, (double)this.activeGUI.zLevel, minU, maxV);
                tessellator.addVertexWithUV(i + (double)coordinate.width, j + (double)coordinate.height, (double)this.activeGUI.zLevel, maxU, maxV);
                tessellator.addVertexWithUV(i + (double)coordinate.width, j + 0.0, (double)this.activeGUI.zLevel, maxU, minV);
                tessellator.addVertexWithUV(i + 0.0, j + 0.0, (double)this.activeGUI.zLevel, minU, minV);
            }
        }
        tessellator.draw();
        GL11.glDisable((int)3089);
    }

    private String generateTemplateString(String text, int max, boolean values, boolean percentage) {
        String template = text;
        if (values) {
            template = template + BTWaila.translator.translateKey("btwaila.util.template.values").replace("{max}", String.valueOf(max)).replace("{current}", String.valueOf(max));
            if (percentage) {
                template = template + " ";
            }
        }
        if (percentage) {
            template = template + BTWaila.translator.translateKey("btwaila.util.template.percentage").replace("{value}", String.format("%.1f", Float.valueOf(100.0f)));
        }
        return template;
    }

    private String generateProgressBarString(String text, int value, int max, boolean values, boolean percentage) {
        float ratio = (float)value / (float)max;
        String template = text;
        if (values) {
            template = template + BTWaila.translator.translateKey("btwaila.util.template.values").replace("{max}", String.valueOf(max)).replace("{current}", String.valueOf(value));
            if (percentage) {
                template = template + " ";
            }
        }
        if (percentage) {
            template = template + BTWaila.translator.translateKey("btwaila.util.template.percentage").replace("{value}", String.format("%.1f", Float.valueOf(ratio * 100.0f)));
        }
        return template;
    }

    public void drawTexturedModalRect(double x, double y, double width, double height, float percent) {
        float z = 0.0f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x + 0.0, y + height, (double)z, 0.0, 1.0);
        tessellator.addVertexWithUV(x + width, y + height, (double)z, (double)percent, 1.0);
        tessellator.addVertexWithUV(x + width, y + 0.0, (double)z, (double)percent, 0.0);
        tessellator.addVertexWithUV(x + 0.0, y + 0.0, (double)z, 0.0, 0.0);
        tessellator.draw();
    }

    public void drawProgressBar(int value, int max, int boxWidth, ColorOptions bgOptions, ColorOptions fgOptions, int offX) {
        float ratio = Math.min((float)value / (float)max, 1.0f);
        int sizeY = 16;
        float progress = (float)boxWidth * ratio;
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureManager textureManager = this.minecraft.textureManager;
        String style = ((BarStyle)((Object)this.modSettings().bTWaila$getBarStyle().value)).name();
        textureManager.bindTexture(textureManager.loadTexture("/assets/btwaila/gui/progressBg_" + style + ".png"));
        this.drawTexturedModalRect(this.posX + offX, this.offY, boxWidth, 16.0, 1.0f);
        if (progress > 0.0f) {
            textureManager.bindTexture(textureManager.loadTexture("/assets/btwaila/gui/progressOverlay_" + style + ".png"));
            this.drawTexturedModalRect(this.posX + offX, this.offY, progress, 16.0, ratio);
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        this.addOffY(16);
    }

    public void drawProgressBarTexture(int value, int max, int boxWidth, TextureOptions bgOptions, TextureOptions fgOptions, int offX) {
        float ratio = (float)value / (float)max;
        int sizeY = 16;
        int progress = (int)Math.ceil((float)boxWidth * ratio);
        IconCoordinate bgCoord = bgOptions.coordinate;
        IconCoordinate fgCoord = fgOptions.coordinate;
        this.drawRect(this.posX + offX, this.offY, this.posX + offX + boxWidth, this.offY + 16, -16777216);
        GL11.glEnable((int)3042);
        this.drawIcon(this.posX + offX, this.offY, this.posX + offX + boxWidth, this.offY + 16, bgCoord, bgOptions.color);
        this.drawIcon(this.posX + offX, this.offY, this.posX + offX + progress, this.offY + 16, fgCoord, fgOptions.color);
        this.addOffY(16);
    }

    public void drawProgressBarWithText(int value, int max, ProgressBarOptions options, int offX) {
        int stringPadding = 5;
        int stringWidth = this.minecraft.font.getStringWidth(this.generateTemplateString(options.text, max, options.values, options.percentage));
        String toDrawText = this.generateProgressBarString(options.text, value, max, options.values, options.percentage);
        int textWidthDif = stringWidth - this.minecraft.font.getStringWidth(toDrawText);
        int width = options.boxWidth;
        if (width == 0) {
            width = stringWidth + stringPadding * 2;
        } else {
            stringPadding = (width - stringWidth) / 2;
        }
        this.drawProgressBar(value, max, width, options.bgOptions, options.fgOptions, offX);
        this.subOffY(12);
        this.drawStringCentered(toDrawText);
        this.addOffY(4);
    }

    public void drawProgressBarTextureWithText(int value, int max, ProgressBarOptions options, int offX) {
        int stringPadding = 5;
        int stringWidth = this.minecraft.font.getStringWidth(this.generateTemplateString(options.text, max, options.values, options.percentage));
        String toDrawText = this.generateProgressBarString(options.text, value, max, options.values, options.percentage);
        int textWidthDif = stringWidth - this.minecraft.font.getStringWidth(toDrawText);
        int width = options.boxWidth;
        if (width == 0) {
            width = stringWidth + stringPadding * 2;
        } else {
            stringPadding = (width - stringWidth) / 2;
        }
        this.drawProgressBarTexture(value, max, width, options.bgOptions, options.fgOptions, offX);
        this.subOffY(12);
        this.drawStringCentered(toDrawText);
        this.addOffY(4);
    }

    public void drawInfiniteStackSizeInventory(Container inventory, int offX) {
        HashMap<Integer, ItemStack> itemList = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack == null) continue;
            int itemId = itemStack.getItem().id;
            int stackSize = itemStack.stackSize;
            if (itemList.containsKey(itemId)) {
                ItemStack stack = (ItemStack)itemList.get(itemId);
                stack.stackSize += stackSize;
                itemList.put(itemId, stack);
                continue;
            }
            itemList.put(itemId, new ItemStack(itemStack.itemID, itemStack.stackSize, itemStack.getMetadata()));
        }
        this.drawItemList(itemList.values().toArray(new ItemStack[0]), offX);
    }

    public void drawItemList(ItemStack[] itemList, int offX) {
        Lighting.enableInventoryLight();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        Tessellator t = Tessellator.instance;
        int itemX = 0;
        int itemY = 0;
        for (ItemStack itemStack : itemList) {
            if (itemStack == null) continue;
            ItemModel model = ItemModelDispatcher.getInstance().getDispatch(itemStack);
            model.renderItemIntoGui(t, this.minecraft.font, this.minecraft.textureManager, itemStack, this.posX + offX + itemX * 16, this.offY + itemY * 16, 1.0f);
            model.renderItemOverlayIntoGUI(t, this.minecraft.font, this.minecraft.textureManager, itemStack, this.posX + offX + itemX * 16, this.offY + itemY * 16, 1.0f);
            if (++itemX < 9) continue;
            itemX = 0;
            ++itemY;
        }
        this.addOffY(8 * (1 + itemY));
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        Lighting.disable();
    }

    public void drawInventory(Container inventory, int offX) {
        Lighting.enableInventoryLight();
        GL11.glEnable((int)32826);
        int invWidth = this.getXSize(this.minecraft);
        int invHeight = this.getYSize(this.minecraft) - (this.offY - this.generateOriginalPosY());
        int invArea = invHeight * invWidth;
        int maxLength = 16;
        float iconLength = inventory.getContainerSize() < 1 ? 16.0f : (float)Math.sqrt((double)invArea / (double)inventory.getContainerSize());
        iconLength = Math.min(16.0f, iconLength);
        iconLength = Math.max(iconLength, 1.0f);
        int itemsWide = (int)Math.floor((float)invWidth / iconLength);
        double scale = (double)iconLength / 16.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        Tessellator t = Tessellator.instance;
        int itemX = 0;
        int itemY = 0;
        GL11.glEnable((int)2929);
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack == null) continue;
            int renderX = (int)((double)((float)(this.posX + offX) + (float)itemX * iconLength) / scale);
            int renderY = (int)((double)((float)this.offY + (float)itemY * iconLength) / scale);
            ItemModel model = ItemModelDispatcher.getInstance().getDispatch(itemStack);
            model.renderItemIntoGui(t, this.minecraft.font, this.minecraft.textureManager, itemStack, renderX, renderY, 1.0f);
            model.renderItemOverlayIntoGUI(t, this.minecraft.font, this.minecraft.textureManager, itemStack, renderX, renderY, 1.0f);
            if (++itemX < itemsWide) continue;
            itemX = 0;
            ++itemY;
        }
        GL11.glScaled((double)(1.0 / scale), (double)(1.0 / scale), (double)(1.0 / scale));
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        this.addOffY(8 * (1 + itemY));
        Lighting.disable();
    }

    protected void drawEntityHealth(Mob entity) {
        int heartsPerRow;
        boolean heartsFlash;
        Random rand = new Random();
        Lighting.disable();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.textureManager.bindTexture(this.minecraft.textureManager.loadTexture("/gui/icons.png"));
        boolean bl = heartsFlash = entity.heartsFlashTime / 3 % 2 == 1;
        if (entity.heartsFlashTime < 10) {
            heartsFlash = false;
        }
        int health = entity.getHealth();
        int prevHealth = entity.prevHealth;
        int hearts = (int)Math.ceil((float)entity.getHealth() / 2.0f);
        int rows = (int)Math.ceil((float)hearts / (float)(heartsPerRow = 19));
        if (rows > (Integer)this.modSettings().bTWaila$getSmallEntityHealthBar().value) {
            int x = this.posX + this.getStartingX(0);
            int y = this.offY;
            this.activeGUI.drawTexturedModalRect(x, y, 16, 0, 9, 9);
            if (heartsFlash) {
                this.activeGUI.drawTexturedModalRect(x, y, 25, 0, 9, 9);
                this.activeGUI.drawTexturedModalRect(x, y, 70, 0, 9, 9);
            }
            this.activeGUI.drawTexturedModalRect(x, y, 52, 0, 9, 9);
            DecimalFormat df = new DecimalFormat("#.#");
            this.drawStringWithShadow(String.format("x %s", df.format((float)health / 2.0f)), 10, 0xFFFFFF);
            this.addOffY(this.getLineHeight());
            return;
        }
        int trueHeartNum = 0;
        for (int row = 0; row < rows; ++row) {
            int heartsToDraw = heartsPerRow;
            if (row == rows - 1) {
                heartsToDraw = hearts - row * heartsPerRow;
            }
            for (int heart = 0; heart < heartsToDraw; ++heart) {
                int width = heartsToDraw * 8;
                int y = this.offY;
                int heartOffset = 0;
                if (heartsFlash) {
                    heartOffset = 1;
                }
                int x = this.posX + this.getStartingX(width) + heart * 8;
                if (health <= 4) {
                    y += rand.nextInt(2);
                }
                this.activeGUI.drawTexturedModalRect(x, y, 16 + heartOffset * 9, 0, 9, 9);
                if (heartsFlash) {
                    if (trueHeartNum * 2 + 1 < prevHealth) {
                        this.activeGUI.drawTexturedModalRect(x, y, 70, 0, 9, 9);
                    }
                    if (trueHeartNum * 2 + 1 == prevHealth) {
                        this.activeGUI.drawTexturedModalRect(x, y, 79, 0, 9, 9);
                    }
                }
                if (trueHeartNum * 2 + 1 < health) {
                    this.activeGUI.drawTexturedModalRect(x, y, 52, 0, 9, 9);
                }
                if (trueHeartNum * 2 + 1 == health) {
                    this.activeGUI.drawTexturedModalRect(x, y, 61, 0, 9, 9);
                }
                ++trueHeartNum;
            }
            this.addOffY(this.getLineHeight());
        }
    }

    protected void drawRect(int minX, int minY, int maxX, int maxY, int argb) {
        int temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.startDrawingQuads();
        tessellator.addVertex((double)minX, (double)maxY, 0.0);
        tessellator.addVertex((double)maxX, (double)maxY, 0.0);
        tessellator.addVertex((double)maxX, (double)minY, 0.0);
        tessellator.addVertex((double)minX, (double)minY, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public EntityRendererItem getItemRenderer() {
        if (itemRender == null) {
            itemRender = new EntityRendererItem();
        }
        return itemRender;
    }

    public static String getEntityName(Entity entity) {
        String entityName;
        if (entity == null) {
            return BTWaila.translator.translateKey("btwaila.tooltip.general.entity.null");
        }
        String string = entityName = entity instanceof Mob ? ((Mob)entity).getDisplayName() : null;
        if (entityName == null || entityName.equalsIgnoreCase("\u00a70")) {
            MobInfoRegistry.MobInfo info = MobInfoRegistry.getMobInfo(entity.getClass());
            entityName = info != null ? BTWaila.translator.translateKey(info.getNameTranslationKey()) : ((NamespaceID)EntityDispatcher.classToIdMap.get(entity.getClass())).toString();
        }
        if (entityName == null) {
            entityName = entity.getClass().getSimpleName();
        }
        return entityName;
    }

    public String getNameFromEntity(Entity entity) {
        return WailaTextComponent.getEntityName(entity);
    }

    @Nullable
    public static String getEntityDesc(Entity entity) {
        if (entity == null) {
            return null;
        }
        MobInfoRegistry.MobInfo info = MobInfoRegistry.getMobInfo(entity.getClass());
        if (info == null) {
            return null;
        }
        return BTWaila.translator.translateKey(info.getDescriptionTranslationKey());
    }

    @Nullable
    public String getDescFromEntity(Entity entity) {
        return WailaTextComponent.getEntityDesc(entity);
    }
}

