/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.tooltips.block;

import java.util.Random;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.lwjgl.opengl.GL11;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoEntry;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;
import toufoumaster.btwaila.util.UUIDHelper;

public class FlagTooltip
extends TileTooltip<TileEntityFlag> {
    @Override
    public void initTooltip() {
        this.addClass(TileEntityFlag.class);
    }

    @Override
    public void drawAdvancedTooltip(TileEntityFlag flag, AdvancedInfoComponent advancedInfoComponent) {
        ItemStack color1 = flag.items[0];
        ItemStack color2 = flag.items[1];
        ItemStack color3 = flag.items[2];
        advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.flag.owner").replace("{name}", flag.owner == null ? BTWaila.translator.translateKey("btwaila.tooltip.flag.owner.none") : String.valueOf(UUIDHelper.getNameFromUUID(flag.owner))), 0);
        advancedInfoComponent.addOffY(2);
        this.renderStringAndStack(advancedInfoComponent, BTWaila.translator.translateKey("btwaila.tooltip.flag.color").replace("{id}", "1") + "    " + (color1 != null ? BTWaila.translator.translateNameKey(color1.getItemKey()) : BTWaila.translator.translateKey("btwaila.tooltip.flag.empty")), 0, color1);
        this.renderStringAndStack(advancedInfoComponent, BTWaila.translator.translateKey("btwaila.tooltip.flag.color").replace("{id}", "2") + "    " + (color2 != null ? BTWaila.translator.translateNameKey(color2.getItemKey()) : BTWaila.translator.translateKey("btwaila.tooltip.flag.empty")), 0, color2);
        this.renderStringAndStack(advancedInfoComponent, BTWaila.translator.translateKey("btwaila.tooltip.flag.color").replace("{id}", "3") + "    " + (color3 != null ? BTWaila.translator.translateNameKey(color3.getItemKey()) : BTWaila.translator.translateKey("btwaila.tooltip.flag.empty")), 0, color3);
    }

    protected void renderStringAndStack(AdvancedInfoComponent advancedInfoComponent, String s, int offX, ItemStack stack) {
        if (stack != null) {
            int y = advancedInfoComponent.getOffY() - 1;
            int x = advancedInfoComponent.getPosX() - 16 + advancedInfoComponent.minecraft.font.getStringWidth(BTWaila.translator.translateKey("btwaila.tooltip.flag.color").replace("{id}", "1") + "    ");
            Tessellator t = Tessellator.instance;
            ItemModel model = ItemModelDispatcher.getInstance().getDispatch(stack);
            model.renderItemIntoGui(t, advancedInfoComponent.getGame().font, advancedInfoComponent.getGame().textureManager, stack, x, y -= 3, 1.0f);
            model.renderItemOverlayIntoGUI(t, advancedInfoComponent.getGame().font, advancedInfoComponent.getGame().textureManager, stack, x, y, 1.0f);
            GL11.glDisable((int)2896);
        }
        advancedInfoComponent.drawStringWithShadow(s, offX);
        advancedInfoComponent.addOffY(4);
    }

    @Override
    public DemoEntry tooltipDemo(Random random) {
        TileEntityFlag demoFlag = new TileEntityFlag();
        demoFlag.items = new ItemStack[]{new ItemStack(Items.DYE, 1, random.nextInt(16)), new ItemStack(Items.DYE, 1, random.nextInt(16)), new ItemStack(Items.DYE, 1, random.nextInt(16))};
        return new DemoEntry(Blocks.FLAG, 0, (TileEntity)demoFlag, new ItemStack[]{Items.FLAG.getDefaultStack()});
    }
}

