/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Hashtable;
import net.minecraft.client.Minecraft;
import turniplabs.halplibe.HalpLibe;
import turniplabs.halplibe.util.DirectoryManager;

public final class SoundHelper {
    private static final Hashtable<String, String> fileCache = new Hashtable();
    public static final File appDirectory;
    public static final File soundDirectory;
    public static final File musicDirectory;
    public static final File streamingDirectory;
    public static final File caveMusicDirectory;

    public static void addCaveMusic(String MOD_ID, String soundSource) {
        if (!HalpLibe.isClient) {
            return;
        }
        if (appDirectory == null) {
            HalpLibe.LOGGER.warn("Resource directory cannot be found, function is only intended to be ran on the Client!");
            return;
        }
        String destination = caveMusicDirectory.getPath();
        String source = (DirectoryManager.getCaveMusicDirectory(MOD_ID) + soundSource).replace("//", "/").trim();
        HalpLibe.LOGGER.info("File source: " + source);
        HalpLibe.LOGGER.info("File destination: " + destination);
        HalpLibe.LOGGER.info(SoundHelper.extract(source, destination, soundSource) + " Added to sound directory");
    }

    public static void addStreaming(String MOD_ID, String soundSource) {
        if (!HalpLibe.isClient) {
            return;
        }
        if (appDirectory == null) {
            HalpLibe.LOGGER.warn("Resource directory cannot be found, function is only intended to be ran on the Client!");
            return;
        }
        String destination = streamingDirectory.getPath();
        String source = (DirectoryManager.getStreamingDirectory(MOD_ID) + soundSource).replace("//", "/").trim();
        HalpLibe.LOGGER.info("File source: " + source);
        HalpLibe.LOGGER.info("File destination: " + destination);
        HalpLibe.LOGGER.info(SoundHelper.extract(source, destination, soundSource) + " Added to sound directory");
    }

    public static void addMusic(String MOD_ID, String soundSource) {
        if (!HalpLibe.isClient) {
            return;
        }
        if (appDirectory == null) {
            HalpLibe.LOGGER.warn("Resource directory cannot be found, function is only intended to be ran on the Client!");
            return;
        }
        String destination = musicDirectory.getPath();
        String source = (DirectoryManager.getMusicDirectory(MOD_ID) + soundSource).replace("//", "/").trim();
        HalpLibe.LOGGER.info("File source: " + source);
        HalpLibe.LOGGER.info("File destination: " + destination);
        HalpLibe.LOGGER.info(SoundHelper.extract(source, destination, soundSource) + " Added to sound directory");
    }

    public static void addSound(String MOD_ID, String soundSource) {
        if (!HalpLibe.isClient) {
            return;
        }
        if (appDirectory == null) {
            HalpLibe.LOGGER.warn("Resource directory cannot be found, function is only intended to be ran on the Client!");
            return;
        }
        String destination = soundDirectory + ("/" + MOD_ID + "/").replace("//", "/");
        String source = (DirectoryManager.getSoundDirectory(MOD_ID) + soundSource).replace("//", "/").trim();
        HalpLibe.LOGGER.info("File source: " + source);
        HalpLibe.LOGGER.info("File destination: " + destination);
        HalpLibe.LOGGER.info(SoundHelper.extract(source, destination, soundSource) + " Added to sound directory");
    }

    private static String extract(String jarFilePath, String destination, String soundSource) {
        if (jarFilePath == null) {
            return null;
        }
        if (fileCache.contains(jarFilePath)) {
            return fileCache.get(jarFilePath);
        }
        try {
            InputStream fileStream = SoundHelper.class.getResourceAsStream(jarFilePath);
            if (fileStream == null) {
                return null;
            }
            File tempFile = new File(new File(destination), soundSource);
            tempFile.getParentFile().mkdirs();
            tempFile.delete();
            Files.createFile(tempFile.toPath(), new FileAttribute[0]);
            tempFile.deleteOnExit();
            OutputStream out = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);
            byte[] buffer = new byte[1024];
            int len = fileStream.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = fileStream.read(buffer);
            }
            fileCache.put(jarFilePath, tempFile.getAbsolutePath());
            fileStream.close();
            out.close();
            return tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            HalpLibe.LOGGER.warn(e.toString());
            for (StackTraceElement element : e.getStackTrace()) {
                HalpLibe.LOGGER.debug(element.toString());
            }
            return null;
        }
    }

    static {
        if (!HalpLibe.isClient) {
            appDirectory = null;
            soundDirectory = null;
            musicDirectory = null;
            streamingDirectory = null;
            caveMusicDirectory = null;
        } else {
            appDirectory = Minecraft.getAppDir((String)"minecraft-bta");
            soundDirectory = new File(appDirectory.getAbsolutePath() + "/resources/mod/sound");
            musicDirectory = new File(appDirectory.getAbsolutePath() + "/resources/mod/music");
            streamingDirectory = new File(appDirectory.getAbsolutePath() + "/resources/mod/streaming");
            caveMusicDirectory = new File(appDirectory.getAbsolutePath() + "/resources/mod/cavemusic");
        }
    }
}

