/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.network;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.PlayerServer;
import org.jetbrains.annotations.NotNull;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public final class NetworkHandler {
    private static final List<Supplier<NetworkMessage>> messagesToRegisterForServer = new LinkedList<Supplier<NetworkMessage>>(Collections.singletonList(MessageIdsNetworkMessage::new));
    private static final Map<Short, BiConsumer<NetworkMessage.NetworkContext, UniversalPacket>> packetReaders = new HashMap<Short, BiConsumer<NetworkMessage.NetworkContext, UniversalPacket>>();
    private static final Map<Class<?>, Short> packetIds = new HashMap();

    private NetworkHandler() {
    }

    public static void internalNetworkHandlerSetup() {
        Packet.addMapping((int)88, (boolean)true, (boolean)true, UniversalPacket.class);
        packetReaders.clear();
        packetIds.clear();
        for (Supplier<NetworkMessage> networkMessage : messagesToRegisterForServer) {
            NetworkHandler.addNetworkMessage(networkMessage);
        }
    }

    public static void internalReceiveUniversalPacket(NetworkMessage.NetworkContext context, UniversalPacket buffer) {
        short type = buffer.readShort();
        if (!packetReaders.containsKey(type)) {
            return;
        }
        packetReaders.get(type).accept(context, buffer);
    }

    public static void registerNetworkMessage(Supplier<NetworkMessage> factory) {
        messagesToRegisterForServer.add(factory);
    }

    private static <T extends NetworkMessage> void addNetworkMessage(Supplier<T> factory) {
        NetworkHandler.registerNetworkMessage((short)packetIds.size(), factory);
    }

    private static <T extends NetworkMessage> void registerNetworkMessage(short id, Supplier<T> factory) {
        NetworkHandler.registerNetworkMessage(id, NetworkHandler.getType(factory), buf -> {
            NetworkMessage instance = (NetworkMessage)factory.get();
            instance.decodeFromUniversalPacket((UniversalPacket)((Object)buf));
            return instance;
        });
    }

    private static <T extends NetworkMessage> void registerNetworkMessage(short id, Class<T> type, Function<UniversalPacket, T> decoder) {
        packetIds.put(type, id);
        packetReaders.put(id, (context, buf) -> {
            NetworkMessage result = (NetworkMessage)decoder.apply((UniversalPacket)((Object)buf));
            result.handle((NetworkMessage.NetworkContext)context);
        });
    }

    private static <T> Class<T> getType(Supplier<T> supplier) {
        return supplier.get().getClass();
    }

    private static UniversalPacket encode(NetworkMessage message) {
        UniversalPacket buf = new UniversalPacket();
        buf.writeShort(packetIds.get(message.getClass()));
        message.encodeToUniversalPacket(buf);
        return buf;
    }

    @Environment(value=EnvType.CLIENT)
    private static void sendToPlayerLocal(NetworkMessage message) {
        message.handle(new NetworkMessage.NetworkContext((Player)Minecraft.getMinecraft().thePlayer));
    }

    @Environment(value=EnvType.SERVER)
    private static void sendToPlayerServer(Player player, NetworkMessage message) {
        ((PlayerServer)player).playerNetServerHandler.sendPacket((Packet)NetworkHandler.encode(message));
    }

    @Environment(value=EnvType.SERVER)
    public static void sendToPlayerMessagesConfiguration(Player player) {
        ((PlayerServer)player).playerNetServerHandler.sendPacket((Packet)NetworkHandler.encode(new MessageIdsNetworkMessage(packetIds)).toPacketCustomPayload());
    }

    public static void sendToPlayer(Player player, NetworkMessage message) {
        if (!EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToPlayerLocal(message);
            return;
        }
        NetworkHandler.sendToPlayerServer(player, message);
    }

    public static void sendToAllPlayers(NetworkMessage message) {
        if (!EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToPlayerLocal(message);
            return;
        }
        MinecraftServer.getInstance().playerList.sendPacketToAllPlayers((Packet)NetworkHandler.encode(message));
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(NetworkMessage message) {
        if (EnvironmentHelper.isSinglePlayer()) {
            NetworkHandler.sendToPlayerLocal(message);
            return;
        }
        Minecraft.getMinecraft().getSendQueue().addToSendQueue((Packet)NetworkHandler.encode(message));
    }

    public static void sendToAllAround(double x, double y, double z, double radius, int dimension, NetworkMessage message) {
        if (!EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToPlayerLocal(message);
            return;
        }
        MinecraftServer.getInstance().playerList.sendPacketToPlayersAroundPoint(x, y, z, radius, dimension, (Packet)NetworkHandler.encode(message));
    }

    private static class MessageIdsNetworkMessage
    implements NetworkMessage {
        Map<Class<?>, Short> packetIds;

        public MessageIdsNetworkMessage() {
        }

        public MessageIdsNetworkMessage(Map<Class<?>, Short> packetIds) {
            this.packetIds = packetIds;
        }

        @Override
        public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
            packet.writeShort((short)this.packetIds.size());
            for (Map.Entry<Class<?>, Short> entry : this.packetIds.entrySet()) {
                packet.writeShort(entry.getValue());
                packet.writeString(entry.getKey().getName());
            }
        }

        @Override
        public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
            this.packetIds = new HashMap();
            int size = packet.readShort();
            try {
                for (int i = 0; i < size; ++i) {
                    short id = packet.readShort();
                    Class<?> messageClass = Class.forName(packet.readString());
                    this.packetIds.put(messageClass, id);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void handle(NetworkMessage.NetworkContext context) {
            if (EnvironmentHelper.isServerEnvironment()) {
                return;
            }
            try {
                packetReaders.clear();
                packetIds.clear();
                for (Map.Entry<Class<?>, Short> entry : this.packetIds.entrySet()) {
                    Class<?> klass = entry.getKey();
                    if (NetworkMessage.class.isAssignableFrom(klass)) {
                        Supplier<NetworkMessage> supplier = () -> {
                            try {
                                return (NetworkMessage)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        };
                        NetworkHandler.registerNetworkMessage(entry.getValue(), supplier);
                        continue;
                    }
                    throw new IllegalArgumentException("Class " + klass.getName() + " does not extend NetworkMessage");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

