/*
 * Decompiled with CFR 0.152.
 */
package turniplabs.halplibe.helper.network;

import com.mojang.nbt.NbtIo;
import com.mojang.nbt.tags.CompoundTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketCustomPayload;
import org.jetbrains.annotations.NotNull;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.mixin.accessors.PacketHandlerServerAccessor;

public class UniversalPacket
extends Packet {
    private byte[] buffer;
    private int writeIndex;
    private int readIndex;

    public UniversalPacket() {
        this.buffer = new byte[0];
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public UniversalPacket(PacketCustomPayload packetCustomPayload) {
        this.buffer = packetCustomPayload.data;
        this.writeIndex = packetCustomPayload.data.length - 1;
        this.readIndex = 0;
    }

    public PacketCustomPayload toPacketCustomPayload() {
        return new PacketCustomPayload("HALPLIBE", this.buffer);
    }

    @Deprecated
    public void read(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        this.buffer = new byte[length];
        dis.readFully(this.buffer, 0, length);
        this.writeIndex = length;
    }

    @Deprecated
    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.buffer.length);
        dos.write(this.buffer);
    }

    public void rawWrite(DataOutputStream dos) throws IOException {
        dos.write(this.buffer);
    }

    public void handlePacket(PacketHandler packetHandler) {
        if (EnvironmentHelper.isServerEnvironment()) {
            this.handlePacketServer(packetHandler);
            return;
        }
        this.handlePacketClient();
    }

    @Environment(value=EnvType.SERVER)
    private void handlePacketServer(PacketHandler packetHandler) {
        NetworkHandler.internalReceiveUniversalPacket(new NetworkMessage.NetworkContext((Player)((PacketHandlerServerAccessor)packetHandler).getPlayerEntity()), this);
    }

    @Environment(value=EnvType.CLIENT)
    private void handlePacketClient() {
        NetworkHandler.internalReceiveUniversalPacket(new NetworkMessage.NetworkContext((Player)Minecraft.getMinecraft().thePlayer), this);
    }

    public int getEstimatedSize() {
        return this.buffer.length;
    }

    public void writeByte(byte value) {
        this.ensureCapacity(1);
        this.buffer[this.writeIndex++] = value;
    }

    public void writeByte(int value) {
        this.writeByte((byte)value);
    }

    public byte readByte() {
        this.ensureReadable(1);
        return this.buffer[this.readIndex++];
    }

    public void writeBytes(int ... values) {
        this.ensureCapacity(values.length);
        for (int value : values) {
            this.buffer[this.writeIndex++] = (byte)value;
        }
    }

    public void writeBytes(byte ... values) {
        this.ensureCapacity(values.length);
        for (byte value : values) {
            this.buffer[this.writeIndex++] = value;
        }
    }

    public void readBytes(byte[] destination, int length) {
        if (length > destination.length) {
            throw new IllegalArgumentException("");
        }
        this.ensureReadable(length);
        System.arraycopy(this.buffer, this.readIndex, destination, 0, length);
        this.readIndex += length;
    }

    public void writeInt(int value) {
        this.ensureCapacity(4);
        this.buffer[this.writeIndex++] = (byte)(value >> 24);
        this.buffer[this.writeIndex++] = (byte)(value >> 16);
        this.buffer[this.writeIndex++] = (byte)(value >> 8);
        this.buffer[this.writeIndex++] = (byte)value;
    }

    public int readInt() {
        this.ensureReadable(4);
        return (this.buffer[this.readIndex++] & 0xFF) << 24 | (this.buffer[this.readIndex++] & 0xFF) << 16 | (this.buffer[this.readIndex++] & 0xFF) << 8 | this.buffer[this.readIndex++] & 0xFF;
    }

    public void writeShort(short value) {
        this.ensureCapacity(2);
        this.buffer[this.writeIndex++] = (byte)(value >> 8);
        this.buffer[this.writeIndex++] = (byte)value;
    }

    public short readShort() {
        this.ensureReadable(2);
        return (short)((this.buffer[this.readIndex++] & 0xFF) << 8 | this.buffer[this.readIndex++] & 0xFF);
    }

    public void writeString(String value) {
        byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeInt(stringBytes.length);
        this.ensureCapacity(stringBytes.length);
        System.arraycopy(stringBytes, 0, this.buffer, this.writeIndex, stringBytes.length);
        this.writeIndex += stringBytes.length;
    }

    public String readString() {
        int length = this.readInt();
        this.ensureReadable(length);
        String value = new String(this.buffer, this.readIndex, length, StandardCharsets.UTF_8);
        this.readIndex += length;
        return value;
    }

    public void writeBoolean(boolean value) {
        this.ensureCapacity(1);
        this.buffer[this.writeIndex++] = (byte)(value ? 1 : 0);
    }

    public boolean readBoolean() {
        this.ensureReadable(1);
        return this.buffer[this.readIndex++] != 0;
    }

    public void writeDouble(double value) {
        long bits = Double.doubleToLongBits(value);
        this.writeLong(bits);
    }

    public double readDouble() {
        long bits = this.readLong();
        return Double.longBitsToDouble(bits);
    }

    public void writeLong(long value) {
        this.ensureCapacity(8);
        for (int i = 7; i >= 0; --i) {
            this.buffer[this.writeIndex++] = (byte)(value >> i * 8);
        }
    }

    public long readLong() {
        this.ensureReadable(8);
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value = value << 8 | (long)(this.buffer[this.readIndex++] & 0xFF);
        }
        return value;
    }

    public void writeEnumConstant(Enum<?> instance) {
        int ordinal = instance.ordinal();
        this.writeByte(ordinal);
    }

    public <T extends Enum<T>> T readEnumConstant(Class<T> enumClass) {
        byte ordinal = this.readByte();
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        return (T)enumConstants[ordinal];
    }

    public void writeCompoundTag(CompoundTag tag) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] buffer = baos.toByteArray();
        this.writeShort((short)buffer.length);
        this.writeBytes(buffer);
    }

    public CompoundTag readCompoundTag() {
        int length = Short.toUnsignedInt(this.readShort());
        if (length == 0) {
            return null;
        }
        byte[] data = new byte[length];
        this.readBytes(data, length);
        try {
            return NbtIo.readCompressed((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream readBytesAsStream(final int length) {
        this.ensureReadable(length);
        return new InputStream(){
            private int remaining;
            {
                this.remaining = length;
            }

            @Override
            public int read() {
                if (this.remaining <= 0) {
                    return -1;
                }
                --this.remaining;
                return UniversalPacket.this.buffer[UniversalPacket.this.readIndex++] & 0xFF;
            }

            @Override
            public int read(byte @NotNull [] b, int off, int len) {
                if (this.remaining <= 0) {
                    return -1;
                }
                int toRead = Math.min(len, this.remaining);
                System.arraycopy(UniversalPacket.this.buffer, UniversalPacket.this.readIndex, b, off, toRead);
                UniversalPacket.this.readIndex += toRead;
                this.remaining -= toRead;
                return toRead;
            }
        };
    }

    private void ensureCapacity(int length) {
        if (this.writeIndex + length > this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + length + 64);
        }
    }

    private void ensureReadable(int length) {
        if (this.readIndex + length > this.writeIndex) {
            throw new IndexOutOfBoundsException("Not enough data to read.");
        }
    }
}

