#extension  GL_EXT_gpu_shader4 : enable

uniform sampler1D texMatrix;
uniform sampler2D depthtex0;

uniform bool tonemap;
uniform bool dither;
uniform bool adaptiveBrightness;
uniform vec3 step;
uniform int bayerSize;
uniform float bayerMax;
uniform float bayerBrightness;

uniform mat4 projectionInverse;
uniform vec2 screen;
uniform float farPlane;
uniform vec3 falloffTone;
uniform vec3 falloffDither;
uniform int falloffType;
uniform vec2 bayerTexMidOffset;
uniform int pixelSize;

float fog_depth() {
    vec4 ndc = projectionInverse * vec4((gl_FragCoord.xy / screen) * 2. - 1., texture2D(depthtex0, texcoord.xy).r * 2. - 1., 1);
    return length(ndc.xyz / ndc.w);
}

float lin_depth() {
    float z = texture2D(depthtex0, texcoord.xy).r * 2.0F - 1.0F;
    float nearPlane = 0.05;
    return (2.0F * nearPlane * farPlane) / (farPlane + nearPlane - z * (farPlane - nearPlane));
}

void main() {
    vec3 shadermod_color = gl_FragColor.rgb;

    float shadermod_depth = falloffType == 0 ? fog_depth() : lin_depth();
    float shadermod_start = falloffDither.x;
    float shadermod_factor = clamp((shadermod_start  - shadermod_depth) / (shadermod_start - falloffDither.y), 0, 1);

    if (dither) {
        int w = (int(mod(gl_FragCoord.x / pixelSize, bayerSize)));
        int h = (int(mod(gl_FragCoord.y / pixelSize, bayerSize)));

        float bayerVal = bayerBrightness * (texture1D(texMatrix, bayerTexMidOffset.x + (w + h*bayerSize) * bayerTexMidOffset.y).r);

        if (falloffDither.z > 0) bayerVal *= falloffDither.z == 1 ? 1 - shadermod_factor : shadermod_factor;
        shadermod_color = clamp(shadermod_color + bayerVal, vec3(0), vec3(1));
    }

    shadermod_start = falloffTone.x;
    shadermod_factor = clamp((shadermod_start  - shadermod_depth) / (shadermod_start - falloffTone.y), 0, 1);
    vec3 oldcol = vec3(shadermod_color);
    if (length(step) == 0) {
        shadermod_color = vec3(round(shadermod_color.r * 0.299 + shadermod_color.g * 0.587 + shadermod_color.b * 0.114));
    } else if (tonemap) {
        vec3 diff = mod(shadermod_color, step);
        shadermod_color = shadermod_color - diff + step * max(sign(diff-step*0.5F), vec3(0));
    }
    if (falloffTone.z == 1) {
        shadermod_color = shadermod_factor * oldcol + (1 - shadermod_factor) * shadermod_color;
    } else if (falloffTone.z == 2){
        shadermod_color = shadermod_factor * shadermod_color + (1 - shadermod_factor) * oldcol;
    }

    gl_FragColor = vec4(shadermod_color, gl_FragColor.a);
}
